/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CMenu.h,v 1.2 1999/09/17 04:20:47 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CMenu_h	// [
#define Included_CMenu_h

#include "pgpClassesConfig.h"

_PGP_BEGIN

// Class CMenu

class CMenu
{
	NOT_COPYABLE(CMenu)

public:
	CMenu();
	CMenu(HMENU menu);
	CMenu(HINSTANCE instance, const char *name);
	~CMenu();

	operator HMENU() const {return mMenu;}
	HMENU	Get() const {return mMenu;}

	PGPBoolean	IsAttached() const;
	PGPBoolean	WeCreated() const {return mWeCreated;}

	PGPUInt32	GetMenuItemCount() const;
	PGPBoolean	GetMenuItemInfo(PGPUInt32 itemID, PGPBoolean byPosition, 
		MENUITEMINFO *pMII) const;
	PGPUInt32	GetMenuState(PGPUInt32 itemID, PGPUInt32 flags);
	void		GetSubMenu(PGPInt32 pos, CMenu& subMenu) const;

	PGPBoolean	InsertMenuItem(PGPUInt32 itemID, PGPBoolean byPosition, 
		MENUITEMINFO *pMII);
	PGPBoolean	ModifyMenu(PGPUInt32 itemID, PGPUInt32 flags, 
		UINT_PTR uidNewItem, const char *newItem);

	PGPUInt32	CheckMenuItem(PGPUInt32 itemID, PGPUInt32 flags);
	PGPUInt32	EnableMenuItem(PGPUInt32 itemID, PGPUInt32 flags);

	PGPUInt32	TrackPopupMenu(PGPUInt32 flags, PGPInt32 x, PGPInt32 y, 
		HWND owner) const;

	void	CreatePopupMenu();
	void	Load(HINSTANCE instance, const char *name);
	void	Attach(HMENU menu);
	void	Clear();

private:
	PGPBoolean	mWeCreated;
	HMENU		mMenu;
};


// Class CMenu member functions

inline 
CMenu::CMenu() : mWeCreated(FALSE), mMenu(NULL)
{
}

inline 
CMenu::CMenu(HMENU menu) : mWeCreated(FALSE), mMenu(NULL)
{
	Attach(menu);
}

inline 
CMenu::CMenu(HINSTANCE instance, const char *name) : 
	mWeCreated(FALSE), mMenu(NULL)
{
	Load(instance, name);
}

inline 
CMenu::~CMenu()
{
	try
	{
		Clear();
	}
	catch (CComboError&) { }
}

inline 
PGPBoolean 
CMenu::IsAttached() const
{
	return IsntNull(mMenu);
}

inline 
PGPUInt32 
CMenu::GetMenuItemCount() const
{
	return ::GetMenuItemCount(mMenu);
}

inline 
PGPBoolean 
CMenu::GetMenuItemInfo(
	PGPUInt32		itemID, 
	PGPBoolean		byPosition, 
	MENUITEMINFO	*pMII) const
{
	return ::GetMenuItemInfo(mMenu, itemID, byPosition, pMII);
}

inline 
PGPUInt32 
CMenu::GetMenuState(PGPUInt32 itemID, PGPUInt32 flags)
{
	return ::GetMenuState(mMenu, itemID, flags);
}

inline 
PGPBoolean 
CMenu::ModifyMenu(
	PGPUInt32	itemID, 
	PGPUInt32	flags, 
	UINT_PTR	uidNewItem, 
	const char *		newItem)
{
	return ::ModifyMenu(mMenu, itemID, flags, uidNewItem, newItem);
}

inline 
PGPBoolean 
CMenu::InsertMenuItem(
	PGPUInt32		itemID, 
	PGPBoolean		byPosition, 
	MENUITEMINFO	*pMII)
{
	return ::InsertMenuItem(mMenu, itemID, byPosition, pMII);
}

inline 
PGPUInt32 
CMenu::CheckMenuItem(PGPUInt32 itemID, PGPUInt32 flags)
{
	return ::CheckMenuItem(mMenu, itemID, flags);
}

inline 
PGPUInt32 
CMenu::EnableMenuItem(PGPUInt32 itemID, PGPUInt32 flags)
{
	return ::EnableMenuItem(mMenu, itemID, flags);
}

inline 
PGPUInt32 
CMenu::TrackPopupMenu(
	PGPUInt32	flags, 
	PGPInt32	x, 
	PGPInt32	y, 
	HWND		owner) const
{
	return ::TrackPopupMenu(mMenu, flags, x, y, 0, owner, NULL);
}

_PGP_END

#endif	// ] Included_CMenu_h
